% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_preproc.R
\name{col_check_rename}
\alias{col_check_rename}
\title{Check the column names and types in read dataframe}
\usage{
col_check_rename(df, table_type = "STAR")
}
\arguments{
\item{df}{input}

\item{table_type}{one in c("STAR","bedpe")}
}
\value{
dataframe with the properly formatted columns
}
\description{
Function to check the correct column names and types in dataframe input.
Tries to guess the column names, if colnames are not provided,
but the types are correct
}
\details{
\itemize{
\item Expected column names for bedpe file
\code{c("chromA","startA",'endA',"chromB", 'startB','endB','readname','flag','strandA','strandB')}
\item Expected colnames for STAR Chimeric junction input:
\item For the 'old' chimeric detection scheme: \code{ c("chr_donorA","brkpt_donorA",
"strand_donorA","chr_acceptorB",
"brkpt_acceptorB","strand_acceptorB",
"junction_type","repeat_left_lenA",
"repeat_right_lenB","read_name",
"start_alnA","cigar_alnA",
"start_alnB","cigar_alnB",
"num_chim_aln","max_poss_aln_score",
"non_chim_aln_score","this_chim_aln_score",
"bestall_chim_aln_score") }
\item For the 'new' chimeric detection scheme
\code{c("chr_donorA","brkpt_donorA",
                  "strand_donorA","chr_acceptorB",
                  "brkpt_acceptorB","strand_acceptorB",
                  "junction_type","repeat_left_lenA",
                  "repeat_right_lenB","read_name",
                  "start_alnA","cigar_alnA",
                  "start_alnB","cigar_alnB")}
}
}
\keyword{internal}
