% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_classification.R
\name{classifyTwoArmChimeras}
\alias{classifyTwoArmChimeras}
\title{Wrapper for classification of the 2arm chimeric reads}
\usage{
classifyTwoArmChimeras(
  gi,
  min_junction_len = 4,
  junctions_gr,
  max_sj_shift = 4
)
}
\arguments{
\item{gi}{\code{GInteractions} object}

\item{min_junction_len}{minimum allowed distance between two chimeric arms}

\item{junctions_gr}{\code{Granges} object with the splice junctions coordinates}

\item{max_sj_shift}{maximum shift between either donor and acceptor splice
sites and corresponding chimreic junction coordinates to count chimeric
junction as splice junction}
}
\value{
\code{GInteractions} object object of the same size with new columns:
\describe{
\item{splicejnc}{filled with 0 or 1}
\item{junction_type}{factor for the junction types}
}
}
\description{
Wraps two procedures for different types of classification for read alignment:
\describe{
\item{overlap type}{test if chimeric junction map to two non-overlapped regions or shorter than defined minimum distance}
\item{splice junction}{test if chimeric junction is also a splice junction}
}
}
\details{
Calls detection of the chimeric junction type, annotates short junctions
on same chromosome an strand as 'short'. Compares chimeric
junctions with splice junctions. Adds results as the new metadata fields
parallel to the input.
}
\examples{
data("RNADuplexesSampleData")
head(RNADuplexSampleGI)
# remove all metadata
mcols(RNADuplexSampleGI) <- NULL
gi <- classifyTwoArmChimeras(RNADuplexSampleGI,
    min_junction_len = 5,
    junctions_gr = SampleSpliceJncGR, max_sj_shift = 10
)
table(gi$splicejnc)
table(gi$junction_type)
}
\seealso{
\link[=getSpliceJunctionChimeras]{DuplexDiscovereR::getChimericJunctionTypes(), DuplexDiscovereR::getSpliceJunctionChimeras()}
}
