% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_annotation.R
\name{annotateGI}
\alias{annotateGI}
\title{Annotate RNA duplexes with features}
\usage{
annotateGI(
  gi,
  anno_gr,
  keys = c("gene_name", "gene_type", "gene_id"),
  ambig_key = keys[1],
  save_ambig = TRUE,
  order_key = NULL,
  order_vec = NULL
)
}
\arguments{
\item{gi}{\code{GInteraction} object to annotate}

\item{anno_gr}{\code{GRanges} object with the \code{keys} columns in the metadata}

\item{keys}{vectors with the names of the features to use for annotation.}

\item{ambig_key}{a which feature to use for recording the annotation ambiguity. Determines the values in \code{ambig_list.A} and \code{ambig_list.B}.}

\item{save_ambig}{When RNA duplex overlaps multiple features, ambiguous annotation for a single key
can be stored in \code{ambig_list.A} and \code{ambig_list.B}. \code{ambig.A} and `ambig.B' fields will be added as the 0/1 label}

\item{order_key}{Experimental. In case RNA duplex overlaps multiple features, this key will be used to sort the overlapping features.}

\item{order_vec}{Experimental. An ordered vector of values in \code{order_key} annotation feature, which sets the priority in case of feature overlap.}
}
\value{
\code{GInteractions} object with new fields
}
\description{
Overlays RNA duplexes with \code{GRanges} annotation object.
}
\details{
For each annotation feature in \code{keys}, i.e if keys=c(keyname1),
then \verb{<keyname1>.A}, \verb{<keyname1>.B} annotation fields will be created, containing the
names of overlapping features
If no overlap is found for the feature, then filed will have NA
}
\examples{
data("RNADuplexesSampleData")
annotateGI(gi = RNADuplexSampleDGs, anno_gr = SampleGeneAnnoGR)

# Prioritisation of the snRNA and lncRNA before mRNA if genes overlap
annotateGI(
    gi = RNADuplexSampleDGs, anno_gr = SampleGeneAnnoGR,
    keys = c("gene_id", "gene_name", "gene_type"),
    order_key = "gene_type",
    order_vec = c("snRNA", "lncRNA", "protein_coding"),
    save_ambig = TRUE
)
}
