% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{RNADuplexSampleDGs}
\alias{RNADuplexSampleDGs}
\title{RNA duplex reads of SPLASH, clustered and collapsed to duplex groups}
\format{
An object of class \code{StrictGInteractions} of length 79.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/sra/?term=SRR3404943}{SequenceReadArcive}
Reads were aligned with STAR and duplex groups were identified
see \code{system.file("extdata/scripts", "DD_data_generation.R", package =
"DuplexDiscovereR")} for details on the data generation procedure.
}
\usage{
data(RNADuplexesSampleData)
}
\value{
\code{GInteractions} with
\itemize{
\item \code{n_reads} : number of reads in the duplex group (DG)
\item \code{dg_id} :id of the duplex group
\item \code{p_val} : BH adjusted p-value of testing to reject hypothesis of DG arising
from random ligation
\item \code{score} : median alignment score in duplex group
\item other columns with \code{.A} and \code{.B} annotating to which genes either arm of the
DG maps
}
}
\description{
\code{GInteractions} duplex group -level object containing detected duplex groups,
annotated with duplex group ids, gene_names and p-values
}
\keyword{datasets}
