% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexDiscovereR-package.R
\docType{package}
\name{DuplexDiscovereR}
\alias{DuplexDiscovereR-package}
\alias{DuplexDiscovereR}
\title{Analysis of the data from RNA duplex probing experiments}
\description{
DuplexDiscovereR is a package for analysing data from RNA cross-linking and
proximity ligation protocols such as SPLASH, PARIS, LIGR-seq and others,
which provide information about intra-molecular RNA-RNA interactions through
chimeric RNA-seq reads. Chimerically aligned fragments in these experiments
correspond to the base-paired stretches (RNA duplexes) of RNA molecules .
DuplexDiscovereR takes input in the form of chimericly or split -aligned reads,
It implements procedures for alignment classification, filtering and efficient
clustering  of  individual chimeric reads into duplex groups (DGs).
Once DGs are found, RNA duplex formation and their hybridization energies are
predicted. Additional metrics, such as p-values or mean DG alignment scores,
can be calculated to rank and analyse the final set of RNA duplexes.
Data from multiple experiments or replicates can be processed separately
and further compared to check the reproducibility of the experimental method.
}
\details{
DuplexDiscovereR
}
\seealso{
\href{`browseVignettes("DuplexDiscovereR")`}{DuplexDiscovereR vignette}
}
\author{
Egor Semenchenko
}
