% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_core_microbiome_custom.R
\name{plot_core_microbiome_custom}
\alias{plot_core_microbiome_custom}
\title{Plot Core Microbiome Prevalence Heatmap (Phyloseq & TSE Compatible)}
\source{
Uses microbiome::plot_core() for core heatmap visualization
}
\usage{
plot_core_microbiome_custom(
  obj,
  taxrank = "Genus",
  select_taxa = NULL,
  detections = list(prevalences = seq(0.03, 1, 0.01), thresholds = 10^seq(log10(0.03),
    log10(1), length = 10), min_prevalence = 0.2, taxa_order = "descending"),
  output_core_csv = NULL,
  output_core_rds = NULL
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} (TSE) object containing microbiome data.}

\item{taxrank}{A character string specifying the taxonomic rank to glom taxa. Default is "Genus".}

\item{select_taxa}{A character vector of taxa to select. Default is \code{NULL}, meaning no specific taxa are selected.}

\item{detections}{A list with the following elements:
\itemize{
\item \code{prevalences}: A numeric vector specifying the prevalence thresholds for plotting. Default is \code{seq(0.03, 1, 0.01)}.
\item \code{thresholds}: A numeric vector specifying the detection thresholds for plotting. Default is \code{10^seq(log10(3e-2), log10(1), length = 10)}.
\item \code{min_prevalence}: A numeric value specifying the minimum prevalence threshold for core microbiome. Default is 0.2.
\item \code{taxa_order}: A character string indicating whether to order taxa by "ascending" or "descending" abundance. Default is "descending".
}}

\item{output_core_csv}{Path to save the core microbiome subset as a CSV file.
Default is \code{NULL}. To avoid writing to the working directory during examples,
use \code{file.path(tempdir(), "core_microbiome.csv")}.}

\item{output_core_rds}{Path to save the core microbiome subset as an RDS file.
Default is \code{NULL}. Use \code{file.path(tempdir(), "core_microbiome.rds")}
to write to a temporary directory during examples or checks.}
}
\value{
A \code{ggplot2} object representing the core microbiome prevalence heatmap.
}
\description{
This function generates a prevalence heatmap of the core microbiome at a specified taxonomic rank.
It allows users to pass custom detection thresholds, prevalence thresholds, and a minimum prevalence
filter, and it provides an option to order taxa either in ascending or descending abundance.
The plot displays a heatmap showing detection thresholds at different prevalence levels.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Subset to only Frog samples (biologically meaningful)
  physeq_frog <- phyloseq::subset_samples(
    physeq_16SOTU,
    Animal.type == "Frog"
  )

  # Remove taxa with zero total abundance
  physeq_frog <- phyloseq::prune_taxa(
    phyloseq::taxa_sums(physeq_frog) > 0,
    physeq_frog
  )

  # Relaxed thresholds to ensure visible core taxa
  custom_detections <- list(
    prevalences    = seq(0.03, 1, 0.01),
    thresholds     = 10^seq(log10(0.03), log10(1), length = 10),
    min_prevalence = 0.3,
    taxa_order     = "ascending"
  )

  # Temporary output paths (required for Bioconductor examples)
  core_csv <- file.path(tempdir(), "core_microbiome_frog.csv")
  core_rds <- file.path(tempdir(), "core_microbiome_frog.rds")

  # Generate the core microbiome prevalence plot
  plot_result <- plot_core_microbiome_custom(
    obj = physeq_frog,
    detections = custom_detections,
    taxrank = "Genus",
    output_core_csv = core_csv,
    output_core_rds = core_rds
  )

  print(plot_result)
}
}
