% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_long_format_data.R
\name{get_long_format_data}
\alias{get_long_format_data}
\title{Convert a Phyloseq or TSE Object into a Long-Format Data Frame}
\usage{
get_long_format_data(obj)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}
}
\value{
A long-format \code{data.frame} containing taxonomic, abundance, and sample metadata.
}
\description{
Converts a \code{phyloseq} or \code{TreeSummarizedExperiment} object into
a long-format data frame, similar to \code{phyloseq::psmelt()}, for compatibility
with visualization functions such as \code{alluvial_plot()}.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Use a small subset for examples
  physeq_small <- phyloseq::prune_taxa(
    phyloseq::taxa_names(physeq_16SOTU)[1:10],
    phyloseq::prune_samples(
      phyloseq::sample_names(physeq_16SOTU)[1:5],
      physeq_16SOTU
    )
  )

  tse_small <- convert_phyloseq_to_tse(physeq_small)
  melted <- get_long_format_data(tse_small)
  head(melted)
}
}
