% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_list_average_scaling_factors.R
\name{calculate_list_average_scaling_factors}
\alias{calculate_list_average_scaling_factors}
\title{Calculate Sample-specific Average Scaling Factors for Multiple Spike-in Groups}
\usage{
calculate_list_average_scaling_factors(
  obj,
  spiked_species_list,
  spiked_cells_list,
  merge_method = c("sum", "max")
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{spiked_species_list}{A list of character vectors. Each vector contains taxon names (at species level) for one spike-in group.}

\item{spiked_cells_list}{A numeric vector specifying the expected number of spike-in cells for each group.
The order must match \code{spiked_species_list}.}

\item{merge_method}{Character. Either \code{"sum"} or \code{"max"}. Controls how OTUs of each spike-in group are merged.}
}
\value{
A named numeric vector of sample-specific scaling factors.
}
\description{
Computes sample-specific scaling factors for multiple groups of spiked species
in a \code{phyloseq} or \code{TreeSummarizedExperiment} object. Each group can have its own
expected spike-in cell count. Scaling factors are calculated per sample and averaged across groups.
Missing spike-in observations in a sample will be handled gracefully by averaging available groups.
}
\details{
The function assumes that the taxonomy table has a \code{Species} column.
The output is suitable for downstream absolute quantification pipelines.
OTUs belonging to each spike-in group will be merged using the specified \code{merge_method}
("sum" or "max") to obtain a group-specific spike-in abundance in each sample.

If a sample does not contain any spike-in sequences, a scaling factor of 1 is assigned.
}
\section{Notes}{

\itemize{
\item This function does not modify the input object.
\item The returned scaling factors are intended to be used for absolute abundance normalization.
}
}

\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  # Load example phyloseq and TSE objects
  data("physeq", package = "DspikeIn")
  data("tse", package = "DspikeIn")

  # Define spike-in species groups and expected cell counts
  spiked_species_list <- list(
    c("Pseudomonas aeruginosa"),
    c("Escherichia coli"),
    c("Clostridium difficile")
  )
  spiked_cells_list <- c(10000, 20000, 15000)

  # --- Phyloseq example ---
  scaling_phyloseq <- calculate_list_average_scaling_factors(
    physeq,
    spiked_species_list,
    spiked_cells_list,
    merge_method = "sum"
  )
  print(scaling_phyloseq)

  # --- TreeSummarizedExperiment (TSE) example ---
  scaling_tse <- calculate_list_average_scaling_factors(
    tse,
    spiked_species_list,
    spiked_cells_list,
    merge_method = "sum"
  )
  print(scaling_tse)
}
}
