% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pre_processing_hashcodes.R
\name{Pre_processing_hashcodes}
\alias{Pre_processing_hashcodes}
\title{Pre-process phyloseq or TSE object based on hashcodes}
\usage{
Pre_processing_hashcodes(
  obj,
  hashcodes,
  merge_method = c("sum", "max"),
  output_prefix = "merged_physeq"
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{hashcodes}{A character vector of taxon hashcodes (OTU row names).}

\item{merge_method}{The method to merge taxa: "sum" or "max".}

\item{output_prefix}{A prefix for the output file names.}
}
\value{
A processed phyloseq or TSE object.
}
\description{
Subsets, merges, and saves taxa based on hashcodes and a specified merge method ("sum" or "max").
This function pre-processes a \code{phyloseq} or \code{TreeSummarizedExperiment} (TSE) object by subsetting, merging,
and saving taxa based on provided hashcodes. It retains taxonomic information and creates intermediate datasets
for further downstream analysis.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Subset to Tetragenococcus species
  tetragenococcus_physeq <- phyloseq::subset_taxa(
    physeq_16SOTU,
    Species \%in\% c("Tetragenococcus_halophilus", "Tetragenococcus_sp.")
  )

  # Extract OTU IDs (hashcodes) for phyloseq object
  hashcodes_physeq <- rownames(phyloseq::otu_table(tetragenococcus_physeq))

  # Remove previous output file if exists
  if (file.exists("merged_physeq_processed.rds")) {
    file.remove("merged_physeq_processed.rds")
  }

  # Run merging with "sum" method for phyloseq
  processed_sum <- Pre_processing_hashcodes(
    physeq_16SOTU,
    hashcodes = hashcodes_physeq,
    merge_method = "sum"
  )

  # Convert to TreeSummarizedExperiment (TSE)
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  tetragenococcus_TSE <- convert_phyloseq_to_tse(tetragenococcus_physeq)

  # Extract hashcodes for TSE
  hashcodes_tse <- rownames(tetragenococcus_TSE)

  # Run merging with "max" method for TSE
  processed_max <- Pre_processing_hashcodes(
    tse_16SOTU,
    hashcodes = hashcodes_tse,
    merge_method = "max"
  )

  # Final cleanup of written file
  file.remove("merged_physeq_processed.rds")
}
}
