% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{qualityControlFlowAI}
\alias{qualityControlFlowAI}
\title{perform QC with flowAI}
\usage{
qualityControlFlowAI(
  ff,
  preTransform = FALSE,
  transList = NULL,
  outputDiagnostic = FALSE,
  outputDir = NULL,
  ...
)
}
\arguments{
\item{ff}{a flowCore::flowFrame}

\item{preTransform}{if TRUE, apply the transList scale transform prior to
running the gating algorithm}

\item{transList}{applied in conjunction with preTransform}

\item{outputDiagnostic}{if TRUE, stores diagnostic files generated by
flowAI in outputDir directory}

\item{outputDir}{used in conjunction with outputDiagnostic}

\item{...}{additional parameters passed to flowAI::flow_auto_qc()}
}
\value{
a flowCore::flowFrame with removed low quality events from the input
}
\description{
this function is a wrapper around flowAI::flow_auto_qc()
function.
It also pre-selects the channels to be handled (=> all signal channels)
}
\examples{

rawDataDir <-
    system.file("extdata", package = "CytoPipeline")
sampleFiles <-
    file.path(rawDataDir, list.files(rawDataDir, pattern = "Donor"))

truncateMaxRange <- FALSE
minLimit <- NULL

# create flowCore::flowSet with all samples of a dataset
fsRaw <- readSampleFiles(
    sampleFiles = sampleFiles,
    whichSamples = "all",
    truncate_max_range = truncateMaxRange,
    min.limit = minLimit)

suppressWarnings(ff_QualityControl <- 
    qualityControlFlowAI(fsRaw[[2]],
                         remove_from = "all", # all default
                         second_fractionFR = 0.1,
                         deviationFR = "MAD",
                         alphaFR = 0.01,
                         decompFR = TRUE,
                         outlier_binsFS = FALSE,
                         pen_valueFS = 500,
                         max_cptFS = 3,
                         sideFM = "both",
                         neg_valuesFM = 1))

}
