#' A subset of ECCITE-seq data (control)
#'
#' Data from Mimitou et al. ECCITE-seq PBMC control sample data, which is a list
#' of three matrices of RNA, ADT and HTO
#'
#' @usage data(CITEseq_example, package = 'CiteFuse')
#'
#' @references Mimitou, E. P., Cheng, A., Montalbano, A., et al. (2019).
#' Multiplexed detection of proteins, transcriptomes, clonotypes and
#' CRISPR perturbations in single cells.
#' Nature Methods, 16(5), 409–412.
#'
#' @source Gene Expression Omnibus with the accession code GSE126310.
"CITEseq_example"



#' A subset of Ligand Receptor Pairs
#'
#' @usage data(lr_pair_subset, package = 'CiteFuse')
"lr_pair_subset"


#' A SingleCellExperiment of ECCITE-seq data
#'
#' Data from Mimitou et al. ECCITE-seq PBMC CTCL sample data
#'
#'
#' @references Mimitou, E. P., Cheng, A., Montalbano, A., et al. (2019).
#' Multiplexed detection of proteins, transcriptomes, clonotypes and
#' CRISPR perturbations in single cells.
#' Nature Methods, 16(5), 409–412.
#'
#' @usage data(sce_ctcl_subset, package = 'CiteFuse')
#'
#' @source Gene Expression Omnibus with the accession code GSE126310.
"sce_ctcl_subset"


#' A SingleCellExperiment of ECCITE-seq data
#'
#' Data from Mimitou et al. ECCITE-seq PBMC Control sample data
#'
#' @usage data(sce_control_subset, package = 'CiteFuse')
#'
#' @references Mimitou, E. P., Cheng, A., Montalbano, A., et al. (2019).
#' Multiplexed detection of proteins, transcriptomes, clonotypes and
#' CRISPR perturbations in single cells.
#' Nature Methods, 16(5), 409–412.
#'
#' @source Gene Expression Omnibus with the accession code GSE126310.
"sce_control_subset"

