% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomicElementDistribution.R
\name{genomicElementDistribution}
\alias{genomicElementDistribution}
\title{Genomic Element distribution}
\usage{
genomicElementDistribution(
  peaks,
  TxDb,
  seqlev,
  nucleotideLevel = FALSE,
  ignore.strand = TRUE,
  promoterRegion = c(upstream = 2000, downstream = 100),
  geneDownstream = c(upstream = 0, downstream = 1000),
  labels = list(geneLevel = c(promoter = "Promoter", geneDownstream = "Downstream",
    geneBody = "Gene body", distalIntergenic = "Distal Intergenic"), ExonIntron = c(exon
    = "Exon", intron = "Intron", intergenic = "Intergenic"), Exons = c(utr5 = "5' UTR",
    utr3 = "3' UTR", CDS = "CDS", otherExon = "Other exon"), group = c(geneLevel =
    "Transcript Level", promoterLevel = "Promoter Level", Exons = "Exon level",
    ExonIntron = "Exon/Intron/Intergenic")),
  labelColors = c(promoter = "#E1F114", geneBody = "#9EFF00", geneDownstream = "#57CB1B",
    distalIntergenic = "#066A4B", exon = "#6600FF", intron = "#8F00FF", intergenic =
    "#DA00FF", utr5 = "#00FFDB", utr3 = "#00DFFF", CDS = "#00A0FF", otherExon =
    "#006FFF"),
  plot = TRUE,
  keepExonsInGenesOnly = TRUE,
  promoterLevel
)
}
\arguments{
\item{peaks}{peak list, \link[GenomicRanges:GRanges-class]{GRanges} object or
a \link[GenomicRanges:GRangesList-class]{GRangesList}.}

\item{TxDb}{an object of \code{\link[GenomicFeatures:TxDb-class]{TxDb}}}

\item{seqlev}{sequence level should be involved. 
Default is all the sequence levels in intersect of peaks and TxDb.}

\item{nucleotideLevel}{Logical. Choose between peak centric and nucleotide
centric view. Default=FALSE}

\item{ignore.strand}{logical. Whether the strand of the input ranges
should be ignored or not. Default=TRUE}

\item{promoterRegion}{numeric. The upstream and downstream of genes to define
promoter region.}

\item{geneDownstream}{numeric. The upstream and downstream of genes to define
gene downstream region.}

\item{labels}{list. A list for labels for the genomic elements.}

\item{labelColors}{named character vector. The colors for each labels.}

\item{plot}{logic. Plot the pie chart for the genomic elements or not.}

\item{keepExonsInGenesOnly}{logic. Keep the exons within annotated gene only.}

\item{promoterLevel}{list. The breaks, labels, and colors for divided range 
of promoters. The breaks must be from 5' -> 3' and the percentage will use
the fixed precedence 3' -> 5'}
}
\value{
Invisible list of data for plot.
}
\description{
Plot pie chart for genomic element distribution
}
\details{
The distribution will be calculated by geneLevel,
ExonIntron, and Exons The geneLevel will be categorized as
promoter region, gene body, gene downstream and distal intergenic region.
The ExonIntron will be categorized as exon, intron and intergenic.
The Exons will be categorized as 5' UTR, 3'UTR and CDS.
The precedence will follow the order of labels defination.
For example, for ExonIntron, if a peak overlap with both exon and intron, 
and exon is specified before intron, then only exon will
be incremented for the same example.
}
\examples{
if (interactive() || Sys.getenv("USER")=="jianhongou"){
  data(myPeakList)
  if(require(TxDb.Hsapiens.UCSC.hg19.knownGene)){
  seqinfo(myPeakList) <- 
  seqinfo(TxDb.Hsapiens.UCSC.hg19.knownGene)[seqlevels(myPeakList)]
  myPeakList <- GenomicRanges::trim(myPeakList)
  myPeakList <- myPeakList[width(myPeakList)>0]
    genomicElementDistribution(myPeakList, 
        TxDb.Hsapiens.UCSC.hg19.knownGene)
    genomicElementDistribution(myPeakList, 
        TxDb.Hsapiens.UCSC.hg19.knownGene,
        nucleotideLevel = TRUE)
    genomicElementDistribution(myPeakList, 
        TxDb.Hsapiens.UCSC.hg19.knownGene,
        promoterLevel=list(
        #from 5' -> 3', fixed precedence 3' -> 5'
        breaks = c(-2000, -1000, -500, 0, 100),
        labels = c("upstream 1-2Kb", "upstream 0.5-1Kb", 
                   "upstream <500b", "TSS - 100b"),
        colors = c("#FFE5CC", "#FFCA99", 
                   "#FFAD65", "#FF8E32")))
  }
}
}
