% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findEnhancers.R
\name{findEnhancers}
\alias{findEnhancers}
\title{Find possible enhancers depend on DNA interaction data}
\usage{
findEnhancers(
  peaks,
  annoData,
  DNAinteractiveData,
  bindingType = c("nearestBiDirectionalPromoters", "startSite", "endSite"),
  bindingRegion = c(-5000, 5000),
  ignore.peak.strand = TRUE,
  ...
)
}
\arguments{
\item{peaks}{peak list, \link[GenomicRanges:GRanges-class]{GRanges} object}

\item{annoData}{annotation data, \link[GenomicRanges:GRanges-class]{GRanges}
object}

\item{DNAinteractiveData}{DNA interaction data,
\link[GenomicRanges:GRanges-class]{GRanges} object with interaction blocks
informations, \link[InteractionSet:InteractionSet]{GInteractions} object, 
or BEDPE file which could be imported by 
\link[trackViewer:importGInteractions]{importGInteractions} or 
BiocIO::\link[BiocIO:export]{import} or assembly in following list:
hg38, hg19, mm10, danRer10, danRer11.}

\item{bindingType}{Specifying the criteria to associate peaks with
annotation. Here is how to use it together with the parameter bindingRegion.
The annotation will be shift to a new position depend on the DNA interaction
region.  \itemize{ \item To obtain peaks within 5kb upstream and up to 3kb
downstream of shift TSS within the gene body, set bindingType = "startSite"
and bindingRegion = c(-5000, 3000) \item To obtain peaks up to 5kb upstream
within the gene body and 3kb downstream of shift gene/Exon End, set
bindingType = "endSite" and bindingRegion = c(-5000, 3000) \item To obtain
peaks with nearest bi-directional enhancer regions within 5kb upstream and
3kb downstream of shift TSS, set bindingType =
"nearestBiDirectionalPromoters" and bindingRegion = c(-5000, 3000) }
\describe{ \item{startSite}{start position of the feature (strand is
considered)} \item{endSite}{end position of the feature (strand is
considered)} \item{nearestBiDirectionalPromoters}{nearest enhancer regions
from both direction of the peaks (strand is considered). It will report
bidirectional enhancer regions if there are enhancer regions in both
directions in the given region (defined by bindingRegion). Otherwise, it
will report the closest enhancer regions in one direction.} }}

\item{bindingRegion}{Annotation range used together with bindingType, which
is a vector with two integer values, default to c (-5000, 5000). The first
one must be no bigger than 0. And the sec ond one must be no less than 1.
For details, see bindingType.}

\item{ignore.peak.strand}{ignore the peaks strand or not.}

\item{...}{Not used.}
}
\value{
Output is a GRanges object of the annotated peaks.
}
\description{
Find possible enhancers by data from chromosome conformation capture
techniques such as 3C, 5C or HiC.
}
\examples{

  bed <- system.file("extdata", 
                     "wgEncodeUmassDekker5CGm12878PkV2.bed.gz",
                     package="ChIPpeakAnno")
  DNAinteractiveData <- toGRanges(gzfile(bed))
  library(EnsDb.Hsapiens.v75)
  annoData <- toGRanges(EnsDb.Hsapiens.v75, feature="gene")
  data("myPeakList")
  findEnhancers(myPeakList[500:1000], annoData, DNAinteractiveData)
  
}
\seealso{
See Also as \code{\link{annotatePeakInBatch}}
}
\author{
Jianhong Ou
}
\keyword{misc}
