% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{filterTrajFeaturesByFF}
\alias{filterTrajFeaturesByFF}
\alias{filterTrajFeaturesByFF,SingleCellExperiment-method}
\title{Filter features by Fano Factor}
\usage{
filterTrajFeaturesByFF(
  sce,
  threshold = 1.7,
  min_expr = 0,
  design = NULL,
  show_plot = TRUE
)
}
\arguments{
\item{sce}{An \code{SingleCellExperiment} object}

\item{threshold}{A Z-score cutoff (default: 1.7)}

\item{min_expr}{Minimum average expression of feature to be considered}

\item{design}{A numeric matrix describing the factors that should be blocked}

\item{show_plot}{Indicates if plot should be shown (default: TRUE)}
}
\value{
A \code{character} vector
}
\description{
Filters trajectory features that exhibit a significantly high fano factor
(index of dispersion) by considering average expression levels.
}
\details{
To identify the most variable features an unsupervised strategy
that controls for the relationship between a features’s average expression
intensity and its expression variability is applied. Features are placed
into 20 bins based on their mean expression. For each bin the fano factor
(a windowed version of the index of dispersion, IOD = variance / mean)
distribution is computed and standardized
(\emph{Z}-score(\emph{x}) = x/sd(\emph{x}) - mean(\emph{x})/sd(\emph{x})).
Features with a \emph{Z}-score
greater than \code{threshold} remain labeled as trajectory feature
in the \code{SingleCellExperiment} object. The parameter \code{min_expr}
defines the minimum average expression level of a feature to be
considered for this filter method. Please note that spike-in controls are
ignored and are not listed as trajectory features.
\cr \cr
To account for systematic bias in the expression data
(e.g., cell cycle effects), a design matrix can be provided for the
learning process. It should list the factors that should be blocked and
their values per sample. It is suggested to construct a design matrix
with \code{model.matrix}.
}
\examples{
# Simulate example data
set.seed(1101)
dat <- simulate_exprs(n_features=15000, n_samples=100)

# Create container
alist <- list(logcounts=dat)
sce <- SingleCellExperiment(assays=alist)

# Filter incrementally
trajFeatureNames(sce) <- filterTrajFeaturesByDL(sce, threshold=2)
trajFeatureNames(sce) <- filterTrajFeaturesByCOV(sce, threshold=0.5)
trajFeatureNames(sce) <- filterTrajFeaturesByFF(sce, threshold=1.7)

# Number of features
length(trajFeatureNames(sce)) #filtered
nrow(sce) #total
}
\seealso{
\code{trajFeatureNames} \code{model.matrix}
}
\author{
Daniel C. Ellwanger
}
