% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_modules.R
\name{scoreModules}
\alias{scoreModules}
\title{Run CSOA separately on the connected components of the overlap graph}
\usage{
scoreModules(scObj, df, components, colStrTemplate = "CSOA_component", ...)
}
\arguments{
\item{scObj}{A Seurat object, SingleCellExperiment object, or
expression matrix.}

\item{df}{A data frame with \code{gene1}, \code{gene2} and component
columns.}

\item{components}{Vector of connected components that will be scored}

\item{colStrTemplate}{Character used in the naming of the component
gene sets.}

\item{...}{Additional parameters passed to \code{runCSOAMultiple}.}
}
\value{
An object of the same class as scObj with CSOA scores
corresponding to the genes defining each connected components
assigned for each cell.
}
\description{
This function runs CSOA on the connected components of the graph having the
filtered overlaps as edges.
}
\examples{
mat <- matrix(0, 500, 300)
rownames(mat) <- paste0('G', seq(500))
colnames(mat) <- paste0('C', seq(300))
mat[sample(8000)] <- runif(8000, max=13)
genes1 <- paste0('G', seq(100))
mat[genes1, 20:50] <- matrix(runif(100 * 31, min = 14, max = 15),
nrow = 100, ncol = 31)
genes2 <- paste0('G', seq(101, 200))
mat[genes2, 70:100] <- matrix(runif(100 * 31, min = 14, max = 15),
nrow = 100, ncol = 31)
genes <- union(genes1, genes2)
mat <- mat[genes, ]
overlapDF <- generateOverlaps(mat)
overlapDF <- processOverlaps(overlapDF)
overlapDF <- connectedComponents(overlapDF)
df <- scoreModules(mat, overlapDF, unique(overlapDF$component))[[2]]
head(df)

}
