% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_modules.R
\name{connectedComponents}
\alias{connectedComponents}
\title{Find the connected components of the graph determined by the overlaps}
\usage{
connectedComponents(df, colName = "component")
}
\arguments{
\item{df}{A data frame with gene1 and gene2 columns.}

\item{colName}{Name of the connected components column to be added.}
}
\value{
An overlap data frame with a column indicated the number of the
connected component.
}
\description{
This function finds the connected components of the graph having the filtered
overlaps as edges.
}
\examples{
df <- data.frame(
gene1 = paste('G', c(1, 2, 6, 7, 8, 9,
11, 25, 32, 17, 18)),
gene2 = paste('G', c(2, 8, 8, 8, 1, 25,
32, 24, 24, 26, 26))
)
connectedComponents(df)

}
