% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{networkPlot}
\alias{networkPlot}
\title{Plot the overlaps as a network}
\usage{
networkPlot(
  overlapDF,
  title = "Top overlaps network plot",
  rankCol = "rank",
  edgeScale = 2,
  nodePointSize = 10,
  nodeTextSize = 2.3,
  ...
)
}
\arguments{
\item{overlapDF}{Overlap data frame.}

\item{title}{Plot title.}

\item{rankCol}{Name of the rank column.}

\item{edgeScale}{Scaling factor used in generating
edge weights.}

\item{nodePointSize}{Point size of graph nodes.}

\item{nodeTextSize}{Text size of graph nodes.}

\item{...}{Additional parameters passed to titlePlot.}
}
\value{
A network plot.
}
\description{
This function plots the graph of the overlap data frame, with genes as vertices
and overlaps as edges.
}
\examples{
overlapDF <- data.frame(gene1 = paste0('G', c(1, 2, 5, 6, 7, 17)),
gene2 = paste0('G', c(2, 5, 8, 11, 11, 11)),
rank = c(1, 1, 3, 3, 3, 3))
networkPlot(overlapDF)

}
