% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{geneRadialPlot}
\alias{geneRadialPlot}
\title{Radial plot for an overlap data frame}
\usage{
geneRadialPlot(
  overlapObj,
  groupLegendName = NULL,
  groupNames = NULL,
  cutoff = NULL,
  title = "Top overlap genes plot",
  extraCircles = 2
)
}
\arguments{
\item{overlapObj}{An overlap data frame or list of overlap data frames.}

\item{groupLegendName}{The title of the group legend; if NULL, no groups will
be distinguished.}

\item{groupNames}{Names of groups. If provided, must be a vector
of the same length as the list of overlap data frames}

\item{cutoff}{Number of retained edges from each overlap data frame after
refiltering. If NULL (as default), no refiltering will be performed}

\item{title}{Plot title.}

\item{extraCircles}{Number of circles drawn beyond those needed to include
the points representing the genes.}
}
\value{
A ggplot object.
}
\description{
This function draws a radial plot for an overlap data frame to illustrate
gene participation in top overlaps.
}
\details{
The function can separate genes by groups. The groups can be, for
instance, different gene sets, or different connected components of the same
overlap data frame.
}
\examples{
edgesDF <- data.frame(gene1 = paste0('G', c(1, 2, 3, 4, 7, 8, 10,
11, 11, 10, 10, 10)),
gene2 = paste0('G', c(2, 5, 1, 8, 4, 9, 12,
13, 14, 13, 16, 14)))
edgesDF <- connectedComponents(edgesDF, 'group')
geneRadialPlot(edgesDF, 'component', extraCircles=1)

}
