% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{featureWes}
\alias{featureWes}
\title{A feature plot with a more distinctive color scheme.}
\usage{
featureWes(
  seuratObj,
  feature,
  title = feature,
  idClass = NULL,
  labelSize = 3,
  titleSize = 12,
  wesPal = "Royal1",
  wesLow = 3,
  wesHigh = 2,
  ...
)
}
\arguments{
\item{seuratObj}{A Seurat object.}

\item{feature}{Seurat feature.}

\item{title}{Plot title.}

\item{idClass}{Column to be used for labelling. If NULL, no column-based
labels will be generated.}

\item{labelSize}{Size of labels. Ignored if idClass is NULL.}

\item{titleSize}{Title size.}

\item{wesPal}{A wesanderson palette.}

\item{wesLow}{Index of color marking low values.}

\item{wesHigh}{Index of color marking high values.}

\item{...}{Additional arguments passed to \code{Seurat::FeaturePlot}.}
}
\value{
A ggplot object.
}
\description{
This function customizes the appearance of \code{Seurat::FeaturePlot} for
improved distinctiveness and aesthetics.
}
\examples{
library(Seurat)
mat <- matrix(0, 3000, 800)
mat[sample(length(mat), 90000)] <- sample(8, 90000, TRUE)
seuratObj <- CreateSeuratObject(counts = mat)
seuratObj <- FindVariableFeatures(seuratObj, nfeatures=200)
seuratObj <- NormalizeData(seuratObj)
seuratObj <- ScaleData(seuratObj)
seuratObj <- RunPCA(seuratObj, verbose=FALSE)
seuratObj <- RunUMAP(seuratObj, dims=1:20, verbose=FALSE)
featureWes(seuratObj, 'Feature3')

}
