% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_cell_scores.R, R/generics.R
\name{attachCellScores.default}
\alias{attachCellScores.default}
\alias{attachCellScores.Seurat}
\alias{attachCellScores.SingleCellExperiment}
\alias{attachCellScores.matrix}
\alias{attachCellScores.dgCMatrix}
\alias{attachCellScores}
\title{Attach CSOA scores to object}
\usage{
\method{attachCellScores}{default}(scObj, scoreDF, ...)

\method{attachCellScores}{Seurat}(scObj, scoreDF, ...)

\method{attachCellScores}{SingleCellExperiment}(scObj, scoreDF, ...)

\method{attachCellScores}{matrix}(scObj, scoreDF, ...)

\method{attachCellScores}{dgCMatrix}(scObj, scoreDF, ...)

attachCellScores(scObj, ...)
}
\arguments{
\item{scObj}{A Seurat object, SingleCellExperiment object, or
expression matrix.}

\item{scoreDF}{Dataframe of CSOA scores}

\item{...}{Additional arguments.}
}
\value{
A Seurat object with CSOA scores added to metadata.

A SingleCellExperiment object with CSOA scores added to
\code{colData}.

A list containing the expression matrix and the CSOA scores data
frame.

A list containing the expression matrix and the CSOA scores data
frame.
}
\description{
This function attaches the data frame of CSOA scores to the input object.
}
\details{
If the input object is of the Seurat or SingleCellExpression class,
it will be returned with added CSOA scores. Otherwise, a list containing the
expression matrix and the CSOA scores data frame will be returned.
}
\examples{
library(Seurat)
mat <- matrix(0, 500, 300)
rownames(mat) <- paste0('G', seq(500))
colnames(mat) <- paste0('C', seq(300))
mat[sample(8000)] <- sample(20, 8000, TRUE)
seuratObj <- CreateSeuratObject(mat)
seuratObj <- NormalizeData(seuratObj)
scores <- data.frame(CSOA = runif(300))
seuratObj <- attachCellScores(seuratObj, scores)
head(seuratObj$CSOA)

}
