% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAGEexp.R
\docType{data}
\name{exampleCAGEexp}
\alias{exampleCAGEexp}
\title{Example CAGEexp object.}
\format{
A \link{CAGEexp} object.
}
\usage{
exampleCAGEexp
}
\description{
Lazy-loaded example CAGEexp object, containing most of the CAGEr data
structures created with the CAGEr modifier functions.
}
\examples{
\dontrun{
pathsToInputFiles <- list.files( system.file("extdata", package = "CAGEr")
                               , "ctss$"
                               , full.names = TRUE)
sampleLabels <- sub( ".chr17.ctss", "", basename(pathsToInputFiles))
exampleCAGEexp <-
  CAGEexp( genomeName     = "BSgenome.Drerio.UCSC.danRer7"
         , inputFiles     = pathsToInputFiles
         , inputFilesType = "ctss"
         , sampleLabels   = sub( ".chr17.ctss", "", basename(pathsToInputFiles)))
exampleCAGEexp <- getCTSS(exampleCAGEexp)
librarySizes(exampleCAGEexp)
colData(exampleCAGEexp)
exampleCAGEexp$l1 <- NULL
exampleCAGEexp <- exampleCAGEexp[,c(5, 2, 1, 3, 4)] # Non-aplhabetic order may help catch bugs
CTSStagCountSE(exampleCAGEexp) <- CTSStagCountSE(exampleCAGEexp)[1:5000,]  # Slim the object
exampleCAGEexp$librarySizes <- sapply(CTSStagCountDF(exampleCAGEexp), sum) # Repair metadata
exampleCAGEexp <- 
  summariseChrExpr(exampleCAGEexp)                |>
  annotateCTSS(exampleZv9_annot)                  |>
  CTSStoGenes()                                   |>
  normalizeTagCount()                             |>
  getExpressionProfiles("CTSS")                   |>
  filterLowExpCTSS()                              |>
  distclu()                                       |>
  annotateTagClusters(exampleZv9_annot)           |>
  cumulativeCTSSdistribution("tagClusters")       |>
  quantilePositions("tagClusters")                |>
  aggregateTagClusters()                          |>
  annotateConsensusClusters(exampleZv9_annot)     |>
  cumulativeCTSSdistribution("consensusClusters") |>
  quantilePositions("consensusClusters")          |>
  getExpressionProfiles("consensusClusters")      |>
  scoreShift( groupX = c("Zf.unfertilized.egg")
            , groupY = "Zf.30p.dome"
            , testKS = TRUE, useTpmKS = FALSE)
save(exampleCAGEexp, file = "data/exampleCAGEexp.RData", compress = "xz")
}
}
\keyword{datasets}
