% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{mapStats}
\alias{mapStats}
\title{Process mapping statistics}
\usage{
mapStats(libs, scope, group = "sampleLabels", facet = NULL, normalise = TRUE)
}
\arguments{
\item{libs}{A data frame with containing columns required by the \code{scope}
chosen.}

\item{scope}{The name of a \dQuote{scope}, that defines which data is plotted
and how it is normalised, or a function that implements a custom scope.
See \code{\link[=mapStatsScopes]{mapStatsScopes()}} for details on each scope.}

\item{group}{A vector of factors defining groups in the data.  By default,
the sample labels (which means no grouping).}

\item{facet}{A vector of factors defining facets in the data (in the sense
of \code{ggplot2}'s \link[ggplot2:facet_wrap]{facet_wrap} function).}

\item{normalise}{Whether to normalise or not. Default: \code{TRUE}.}
}
\value{
Returns a data frame with mean and standard deviation of normalised
mapping statistics, plus absolute positions for the error bars.  The first
column, \code{group}, is a vector of factors sorted with the \code{\link[gtools:mixedsort]{gtools::mixedorder()}}
function.  The facet column, if any, is always called \code{facet}.
}
\description{
Using a data frame containing mapping statistics in counts,
transform the data in percentages that can be used for stacked barplots.
}
\details{
See the plotAnnot vignette and the \code{\link[=mapStatsScopes]{mapStatsScopes()}}
help page for details on what the scopes are.

See \url{http://stackoverflow.com/questions/10417003/stacked-barplot-with-errorbars-using-ggplot2} about stacked barplot.
}
\examples{
CAGEr:::mapStats(as.data.frame(colData(exampleCAGEexp)), "counts", sampleLabels(exampleCAGEexp))
CAGEr:::mapStats(as.data.frame(colData(exampleCAGEexp)), "counts", c("A", "A", "B", "B", "C"))

}
\seealso{
\link{plotAnnot}, \link{mapStatsScopes}
}
\author{
Charles Plessy
}
