% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSSlogo.R
\name{TSSlogo}
\alias{TSSlogo}
\alias{TSSlogo,CAGEexp-method}
\alias{TSSlogo,TagClusters-method}
\alias{TSSlogo,ConsensusClusters-method}
\alias{TSSlogo,CTSS-method}
\title{TSS logo}
\usage{
TSSlogo(x, upstream = 10, downstream = 10)

\S4method{TSSlogo}{CAGEexp}(x, upstream = 10, downstream = 10)

\S4method{TSSlogo}{TagClusters}(x, upstream = 10, downstream = 10)

\S4method{TSSlogo}{ConsensusClusters}(x, upstream = 10, downstream = 10)

\S4method{TSSlogo}{CTSS}(x, upstream = 10, downstream = 10)
}
\arguments{
\item{x}{A \code{\link{CTSS}}, a \code{\link{TagClusters}} or a \code{\link{ConsensusClusters}} object.}

\item{upstream}{Number of bases to plot upstream the TSS.}

\item{downstream}{Number of bases to plot downstream the TSS, including the
TSS itself.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} object showing the sequence logo.  The
coordinates displayed are negative for upstream sequences and positive
downstream.  The position of the TSS is set to 1.
}
\description{
Plot the sequence logo of the region flanking the TSS.  When this function
is given \emph{tag clusters} or \emph{consensus clusters}, it uses the \emph{dominant peak}
as the transcription start site.
}
\details{
This function will only work if the \code{\link{CAGEexp}} object was built with a
\code{\link[BSgenome:BSgenome-class]{BSgenome::BSgenome}} package, as it needs to extract genomic sequences.
}
\examples{
TSSlogo(exampleCAGEexp|>consensusClustersGR(), 20, 10)

}
\seealso{
Other CAGEr plot functions: 
\code{\link{hanabiPlot}()},
\code{\link{plotAnnot}()},
\code{\link{plotCorrelation}()},
\code{\link{plotExpressionProfiles}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{plotReverseCumulatives}()}
}
\author{
Charles Plessy
}
\concept{CAGEr TSS functions}
\concept{CAGEr plot functions}
