% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_Draw.R
\name{BASiCS_Draw}
\alias{BASiCS_Draw}
\title{Generate a draw from the posterior of BASiCS using the
generative model.}
\usage{
BASiCS_Draw(
  Chain,
  BatchInfo = gsub(".*_Batch([0-9a-zA-Z])", "\\\\1", colnames(Chain@parameters[["nu"]])),
  N = sample(nrow(Chain@parameters[["nu"]]), 1)
)
}
\arguments{
\item{Chain}{An object of class \code{\linkS4class{BASiCS_Chain}}.}

\item{BatchInfo}{Vector of batch information from the SingleCellExperiment
object used as input to BASiCS_MCMC.}

\item{N}{The integer index for the draw to be used to sample from the 
posterior predictive distribution. If not supplied, a random value is chosen.}
}
\value{
An object of class \code{\link[SingleCellExperiment]{SingleCellExperiment-class}},
including synthetic data generated by the model implemented in BASiCS.
}
\description{
\code{BASiCS_Draw} creates a simulated dataset from the
posterior of a fitted model implemented in BASiCS.
}
\examples{
data(ChainSC)
BASiCS_Draw(ChainSC)

data(ChainSC)
BASiCS_Draw(ChainSC)

}
\references{
Vallejos, Marioni and Richardson (2015). PLoS Computational Biology.
}
\author{
Alan O'Callaghan
}
