#' Extract from the chain obtained for the Grun et al (2014) data:
#' pool-and-split samples
#'
#' Small extract (75 MCMC iterations, 350 randomly selected genes) from the 
#' chain obtained for the pool-and-split samples
#' (this corresponds to the RNA 2i samples in Grun et al, 2014).
#' 
#' @name ChainRNA
#' @format An object of class \code{\linkS4class{BASiCS_Chain}} 
#' containing 75 MCMC iterations.
#'
#' @references 
#' 
#' Grun, Kester and van Oudenaarden (2014). Nature Methods.
#' 
NULL

#' Extract from the chain obtained for the Grun et al (2014) data:
#' single-cell samples
#'
#' Small extract (75 MCMC iterations, 350 randomly selected genes) from the 
#' chain obtained for the pool-and-split samples
#' (this corresponds to the SC 2i samples in Grun et al, 2014). 
#' 
#' @name ChainSC
#' @format An object of class \code{\linkS4class{BASiCS_Chain}} 
#' containing 75 MCMC iterations.
#'
#' @references 
#' 
#' Grun, Kester and van Oudenaarden (2014). Nature Methods. 
#' 
NULL

#' Extract from the chain obtained for the Grun et al (2014) data: 
#' pool-and-split samples (regression model)
#'
#' Small extract (75 MCMC iterations, 350 randomly selected genes) from the 
#' chain obtained for the pool-and-split samples 
#' (this corresponds to the RNA 2i samples in Grun et al, 2014). 
#' 
#' @name ChainRNAReg
#' @format An object of class \code{\linkS4class{BASiCS_Chain}} 
#' containing 75 MCMC iterations.
#'
#' @references 
#' 
#' Grun, Kester and van Oudenaarden (2014). Nature Methods. 
#' 
NULL

#' Extract from the chain obtained for the Grun et al (2014) data: 
#' single-cell samples (regression model)
#'
#' Small extract (75 MCMC iterations, 350 randomly selected genes) from the 
#' chain obtained for the pool-and-split samples
#' (this corresponds to the SC 2i samples in Grun et al, 2014). 
#' 
#' @name ChainSCReg
#' @format An object of class \code{\linkS4class{BASiCS_Chain}} 
#' containing 75 MCMC iterations.
#'
#' @references 
#' 
#' Grun, Kester and van Oudenaarden (2014). Nature Methods. 
#' 
NULL
