% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avworkspace-methods.R
\name{avworkspace-methods}
\alias{avworkspace-methods}
\alias{avworkspaces,gcp-method}
\alias{avworkspace_namespace,gcp-method}
\alias{avworkspace_name,gcp-method}
\alias{avworkspace,gcp-method}
\alias{avworkspace_clone,gcp-method}
\title{AnVIL Workspace GCP methods}
\usage{
\S4method{avworkspaces}{gcp}(..., platform = cloud_platform())

\S4method{avworkspace_namespace}{gcp}(
  namespace = NULL,
  warn = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avworkspace_name}{gcp}(name = NULL, warn = TRUE, ..., platform = cloud_platform())

\S4method{avworkspace}{gcp}(workspace = NULL, ..., platform = cloud_platform())

\S4method{avworkspace_clone}{gcp}(
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  to_namespace = namespace,
  to_name,
  storage_region = "US",
  bucket_location,
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{...}{additional arguments passed as-is to the \code{gsutil} subcommand.}

\item{platform}{\code{gcp()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"gcp"} class for Google Cloud Platform
workspaces on AnVIL.}

\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{warn}{logical(1) when \code{TRUE} (default), generate a warning
when the workspace namespace or name cannot be determined.}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, e.g.,
\code{avworkspace_name()}.}

\item{workspace}{when present, a \code{character(1)} providing the
concatenated namespace and name, e.g.,
\code{"bioconductor-rpci-anvil/Bioconductor-Package-AnVIL"}}

\item{to_namespace}{character(1) workspace (billing account) in
which to make the clone.}

\item{to_name}{character(1) name of the cloned workspace.}

\item{storage_region}{character(1) region (NO multi-region, except the
default) in which bucket attached to the workspace should be created.}

\item{bucket_location}{character(1) DEFUNCT; use \code{storage_region} instead.
Region (NO multi-region, except the default) in which bucket attached to
the workspace should be created.}
}
\value{
\code{avworkspace_namespace()}, and \code{avworkspace_name()} return
\code{character(1)} identifiers. \code{avworkspace()} returns the
character(1) concatenated namespace and name. The value
returned by \code{avworkspace_name()} will be percent-encoded (e.g.,
spaces \code{" "} replaced by \code{"\%20"}).

\code{avworkspace_clone()} returns the namespace and name, in
the format \code{namespace/name}, of the cloned workspace.
}
\description{
\code{avworkspace_namespace()} and \code{avworkspace_name()} are utiliity
functions to retrieve workspace namespace and name from environment
variables or interfaces usually available in AnVIL notebooks or RStudio
sessions. \code{avworkspace()} provides a convenient way to specify workspace
namespace and name in a single command. \code{avworkspace_clone()} clones
(copies) an existing workspace, possibly into a new namespace (billing
account).
}
\details{
\code{avworkspace_namespace()} is the billing account. If the
\verb{namespace=} argument is not provided, try \code{gcloud_project()},
and if that fails try \code{Sys.getenv("WORKSPACE_NAMESPACE")}.

\code{avworkspace_name()} is the name of the workspace as it appears in
\url{https://app.terra.bio/#workspaces}. If not provided,
\code{avworkspace_name()} tries to use \code{Sys.getenv("WORKSPACE_NAME")}.

Namespace and name values are cached across sessions, so explicitly
providing \verb{avworkspace_name*()} is required at most once per
session. Revert to system settings with arguments \code{NA}.
}
\section{Functions}{
\itemize{
\item \code{avworkspaces(gcp)}: list workspaces in the current project as a
tibble

\item \code{avworkspace_namespace(gcp)}: Get or set the namespace of the current
workspace

\item \code{avworkspace_name(gcp)}: Get or set the name of the current workspace

\item \code{avworkspace(gcp)}: Get the current workspace namespace and name
combination

\item \code{avworkspace_clone(gcp)}: Clone the current workspace

}}
\examples{
if (has_avworkspace(platform = gcp())) {
    avworkspaces()
    avworkspace_namespace()
    avworkspace_name()
    avworkspace()
}
}
