\name{vstruct}
\alias{vstruct}
\title{Construct intermediate values used to compute the prediction strength. }
\description{
  As part of the weighted voting methodology Golub et al also proposed
  an indicator of prediction strength. This function produces some
  intermediate computations that can then be used to obtain votes and
  other quantities.
}
\usage{
vstruct(eset, c)
}
\arguments{
  \item{eset}{ An instance of the \code{exprSet} class.}
  \item{c}{A categorical variable, defining two classes. }
}
\details{
  This function computes \code{P(x,c)} for all genes, \code{x} in
  \code{eset}. It also computes the within group means. Both are
  returned in an object of class \code{vstruct}.
}
\value{
An object of class \code{vstruct}. It has two slots,
  \item{wts }{These are the correlations between the genes and the class
  variable \code{c}.}
  \item{mns }{A matrix with two rows and one column for each gene. The
    elements are the within group means for each gene.}
}
\references{ Molecular Classification of Cancer: Class Discovery and
  Class Prediction by 
Gene Expression Monitoring, Science, 531-537, 1999, T. R. Golub and
D. K. Slonim and P. Tamayo and C. Huard and M. Gaasenbeek and
J. P. Mesirov and H. Coller and M.L. Loh and J. R. Downing and
M. A. Caligiuri and C. D. Bloomfield and E. S. Lander
}
\author{R. Gentleman}
\seealso{\code{\link{dovote}}}

  \examples{
   library(golubEsets)
   vs <- vstruct(golubMerge[1:20,], golubMerge$ALL)
}
\keyword{ manip }
