\name{votes}
\alias{votes}
\title{ Compute the votes for each gene. }
\description{
   Golub et al define a method they call weighted voting. This function
   computes the vote cast for each class.
}
\usage{
votes(eset, c)
}
\arguments{
  \item{eset}{An instance of the \code{exprSet} class. }
  \item{c}{A categorical variable, defining two classes. }
}
\details{
  A vote is defined to be the absolute value of the difference between
  the observed value for a gene and the average of the two within sample
  means. 
  The vote is cast for the group with mean closest to the expressed
  value of the gene. The weights are computed using \code{\link{P}}.
}
\value{
  A list with the following components.
  \item{closer }{A genes by samples array indicating which class is closest.}
  \item{mns }{The average of the two within group means.}
  \item{wts}{The wts are per gene and are computed using
    \code{\link{P}}.}
  \item{vote }{The numerical vote, a genes by samples array.}
}
\references{ Molecular Classification of Cancer: Class Discovery and
  Class Prediction by 
Gene Expression Monitoring, Science, 531-537, 1999, T. R. Golub and
D. K. Slonim and P. Tamayo and C. Huard and M. Gaasenbeek and
J. P. Mesirov and H. Coller and M.L. Loh and J. R. Downing and
M. A. Caligiuri and C. D. Bloomfield and E. S. Lander
}
\author{R. Gentleman}
\seealso{\code{\link{P}}, \code{\link{P}}}

  \examples{
   library(golubEsets)
   vts <- votes(golubMerge[1:20,], golubMerge$ALL)
}
\keyword{manip }
