\name{permCor}
\alias{permCor}
\title{ Compute Permutations }
\description{
  In Note 17 and in the caption for Figure 2, Golub et al discuss a
  permutation test. This function computes the relevant permutations of
  the data set.
}
\usage{
permCor(exprSet, c, seed, nPerm)
}
\arguments{
  \item{exprSet}{An object of class \code{exprSet} }
  \item{c}{A vector defining two classes, the length is the same as the
    number of samples. }
  \item{seed}{A seed for the random number generator, so results can be
    reproduced. }
  \item{nPerm}{The number of permutations desired. }
}
\details{
  For each permutation the elements of \code{c} are rearranged and the
  correlation (\code{P}) for each gene is computed.
}
\value{
A list with one entry for each permutation. The element is the vector of
correlations, one for each gene, with the permuted class vector.
}
\references{ Molecular Classification of Cancer: Class Discovery and
  Class Prediction by 
Gene Expression Monitoring, Science, 531-537, 1999, T. R. Golub and
D. K. Slonim and P. Tamayo and C. Huard and M. Gaasenbeek and
J. P. Mesirov and H. Coller and M.L. Loh and J. R. Downing and
M. A. Caligiuri and C. D. Bloomfield and E. S. Lander
 }
\author{R. Gentleman}

\seealso{\code{\link{P}}}

\examples{
  library(golubEsets)
  pC1 <- permCor(golubTest[1:100,], golubTest$ALL, 1234, 10)
}
\keyword{manip }
