\name{dovote}
\alias{dovote}
\title{ Compute the weighted vote for the supplied sample. }
\description{
  The per group votes, the prediction strength (PS) and which group was
  selected are computed for a given sample, using an object of class
  \code{vstruct}.
}
\usage{
dovote(x, vstr)
}
\arguments{
  \item{x}{A vector of gene expressions for some samples. }
  \item{vstr}{An object of class \code{vstruct} that describes the
    reference set. }
}
\details{
  The various test statistics required for the weighted voting algorithm
  are computed for the given vector of gene expressions. The results are
  returned in a list.
}
\value{
A list containing:
  \item{PS }{The prediction strength}
  \item{vAML }{The weighted votes for AML.}
  \item{vALL }{The weighted votes for ALL.}
  \item{wh }{The class (either ALL or AML) that the vote is cast for.}
}
\references{ Molecular Classification of Cancer: Class Discovery and
  Class Prediction by 
Gene Expression Monitoring, Science, 531-537, 1999, T. R. Golub and
D. K. Slonim and P. Tamayo and C. Huard and M. Gaasenbeek and
J. P. Mesirov and H. Coller and M.L. Loh and J. R. Downing and
M. A. Caligiuri and C. D. Bloomfield and E. S. Lander
}
\author{R. Gentleman}
\seealso{\code{\link{vstruct}}}

\examples{
   library(golubEsets)
   vs <- vstruct(golubTest[1:20,], golubTest$ALL)
   vts <- dovote(exprs(golubTrain)[1:20,1], vs)
}
\keyword{ manip}
