## ----setup, echo=FALSE---------------------------------------------------
library(UseBioconductor)
stopifnot(BiocInstaller::biocVersion() == "3.1")

## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy=FALSE)

## ----S3------------------------------------------------------------------
x <- rnorm(1000)
y <- x + rnorm(1000, .5)
df <- data.frame(x=x, y=y)
fit <- lm(y ~ x, df)
class(fit)
methods(class=class(fit))
methods(anova)
plot(y ~ x, df)
abline(fit, col="red", lwd=2)

## ----S4------------------------------------------------------------------
suppressPackageStartupMessages({
    library(IRanges)
})
start <- as.integer(runif(1000, 1, 1e4))
width <- as.integer(runif(length(start), 50, 100))
ir <- IRanges(start, width=width)
coverage(ir)
findOverlaps(ir)
showMethods("coverage")

## ----showMethods, eval=FALSE---------------------------------------------
#  showMethods(classes=class(ir), where=search())

## ----S4-methods----------------------------------------------------------
suppressPackageStartupMessages({
    library(GenomicRanges)
})
showMethods("coverage")

## ------------------------------------------------------------------------
suppressPackageStartupMessages({
    library(Biostrings)
})
data(phiX174Phage)
m <- consensusMatrix(phiX174Phage)[1:4,]
polymorphic <- colSums(m > 0) > 1
endoapply(phiX174Phage, `[`, polymorphic)

