## ----style, echo=FALSE, results='asis'-----------------------------------
BiocStyle::markdown()

## ----eval=FALSE----------------------------------------------------------
#  y = beta0 + beta1 * height + beta2 * weight + beta3 * shoe_size

## ----message=FALSE-------------------------------------------------------
library(airway)
data("airway")
se <- airway
colData(se)
library("DESeq2")
dds <- DESeqDataSet(se, design = ~ cell + dex)  

## ----message=FALSE-------------------------------------------------------
library(MLSeq)
filepath = system.file("extdata/cervical.txt", package = "MLSeq")
cervical = read.table(filepath, header = TRUE)

## ------------------------------------------------------------------------
rld <- rlog(dds)   
head(assay(rld))    

## ------------------------------------------------------------------------
sampleDists <- dist( t( assay(rld) ) )
sampleDists

## ----message=FALSE-------------------------------------------------------
library("gplots")
library("RColorBrewer")

sampleDistMatrix <- as.matrix( sampleDists )
rownames(sampleDistMatrix) <- paste( rld$dex, rld$cell, sep="-" )
colors <- colorRampPalette( rev(brewer.pal(9, "Blues")) )(255)
hc <- hclust(sampleDists)
heatmap.2( sampleDistMatrix, Rowv=as.dendrogram(hc),
          symm=TRUE, trace="none", col=colors,
          margins=c(2,10), labCol=FALSE )


## ------------------------------------------------------------------------
plotPCA(rld, intgroup = c("dex", "cell"))

## ------------------------------------------------------------------------
library(ggplot2)
mds <- data.frame(cmdscale(sampleDistMatrix))
mds <- cbind(mds, colData(rld))
qplot(X1,X2,color=dex,shape=cell,data=as.data.frame(mds))

## ----plotMDS-------------------------------------------------------------
suppressPackageStartupMessages({
   library(limma)
   library(DESeq2)
   library(airway)
})
plotMDS(assay(rld), col=as.integer(dds$dex), pch=as.integer(dds$cell))

## ------------------------------------------------------------------------
set.seed(9)

class = data.frame(condition = factor(rep(c(0, 1), c(29, 29))))

nTest = ceiling(ncol(cervical) * 0.2)
ind = sample(ncol(cervical), nTest, FALSE)

cervical.train = cervical[, -ind]
cervical.train = as.matrix(cervical.train + 1)
classtr = data.frame(condition = class[-ind, ])

cervical.test = cervical[, ind]
cervical.test = as.matrix(cervical.test + 1)
classts = data.frame(condition = class[ind, ])

## ------------------------------------------------------------------------
cervical.trainS4 = DESeqDataSetFromMatrix(countData = cervical.train, 
        colData = classtr, formula(~condition))
cervical.trainS4 = DESeq(cervical.trainS4, fitType = "local")

cervical.testS4 = DESeqDataSetFromMatrix(countData = cervical.test, colData = classts,
formula(~condition))
cervical.testS4 = DESeq(cervical.testS4, fitType = "local")


## ------------------------------------------------------------------------
svm = classify(data = cervical.trainS4, method = "svm", normalize = "deseq",
deseqTransform = "vst", cv = 5, rpt = 3, ref = "1")
svm

## ------------------------------------------------------------------------
getSlots("MLSeq")

## ------------------------------------------------------------------------
trained(svm)

## ------------------------------------------------------------------------
pred.svm = predictClassify(svm, cervical.testS4)
table(pred.svm, relevel(cervical.testS4$condition, 2))

## ------------------------------------------------------------------------
rf = classify(data = cervical.trainS4, method = "randomforest", 
        normalize = "deseq", deseqTransform = "vst", cv = 5, rpt = 3, ref = "1")
trained(rf)
pred.rf = predictClassify(rf, cervical.testS4)
table(pred.rf, relevel(cervical.testS4$condition, 2))

## ------------------------------------------------------------------------
sessionInfo()

