library(shiny)
library(lattice)
    
shinyServer(function(input, output) {

    dataInput <- reactive({
        if (is.null(input$datafile))
            return(NULL)
        read.csv(input$datafile$datapath)
    })

    output$toptable <- renderTable({
        csv <- dataInput()
        if (is.null(csv))
            return(NULL)
        o <- order(abs(csv$log2FoldChange),
            decreasing=TRUE)
        csv[head(o, 20),]
    })

    output$volcano <- renderPlot({
        csv <- dataInput()
        if (is.null(csv))
            return(NULL)
        print(xyplot(-log10(pvalue) ~ log2FoldChange, csv))
    })
})
