
## ----knitr-settings, echo=FALSE------------------------------------------
library(knitr)
opts_chunk$set(tidy=FALSE)


## ----exmaple-data-input, echo=FALSE--------------------------------------
fl <- system.file(package="SummerX", "extdata", "abc.csv")
stopifnot(file.exists(fl))
abc <- read.csv(fl, row.names=1)
fl <- system.file(package="SummerX", "extdata", "BRFSS-subset.csv")
stopifnot(file.exists(fl))
brfss <- read.csv(fl)


## ----example-data, eval=FALSE--------------------------------------------
## fileName <- file.choose()  # 'abc.csv'
## abc <- read.csv(fileName, row.names=1)


## ----ShortRead-vis, eval=FALSE, tidy=FALSE-------------------------------
## ## Create a plot from a
## ## matrix
## matplot(t(abc), type="l",
##   lty=1, lwd=3,
##   xlab="Cycle",
##   ylab="Count",
##   cex.lab=2)
## ## Add a legend
## legend("topright",
##   legend=rownames(abc),
##   lty=1, lwd=3, col=1:5,
##   cex=1.8)


## ----brfss-base-input-in, echo=FALSE-------------------------------------
fl <- system.file(package="SummerX", "extdata", "BRFSS-subset.csv")
brfss <- read.csv(fl)
brfss2010 <- brfss[brfss$Year == "2010",]


## ----brfss-base-input, eval=FALSE----------------------------------------
## brfss <- read.csv(file.choose()) # 'BRFSS-subset.csv'
## brfss2010 <- brfss[brfss$Year == "2010",]


## ----brfss-base-plot, eval=FALSE-----------------------------------------
## ## set layout, capture old options
## opar <- par(mfcol=c(1, 2))
## plot(sqrt(Weight) ~ Height,
##     brfss2010[brfss2010$Sex == "Female", ],
##     main="2010, Female")
## plot(sqrt(Weight) ~ Height,
##     brfss2010[brfss2010$Sex == "Male", ],
##     main="2010, Male")
## ## restore old options
## par(mfcol=c(1, 1))


## ----brfss-input-in, echo=FALSE------------------------------------------
fl <- system.file(package="SummerX", "extdata", "BRFSS-subset.csv")
brfss <- read.csv(fl)


## ----brfss-input, eval=FALSE---------------------------------------------
## brfss <- read.csv(file.choose()) # 'BRFSS-subset.csv'


## ----lattice, eval=FALSE-------------------------------------------------
## library(lattice)
## xyplot(sqrt(Weight) ~ Height | Sex, brfss2010)


## ----lattice-violin, eval=FALSE------------------------------------------
## bwplot(sqrt(Weight) ~ factor(Year) | Sex, brfss,
##     panel=panel.violin)


## ----ggplot2-input-in, echo=FALSE----------------------------------------
fl <- system.file(package="SummerX", "extdata", "BRFSS-subset.csv")
brfss <- read.csv(fl)
brfss2010 <- brfss[brfss$Year == "2010",]


## ----ggplot2-input, eval=FALSE-------------------------------------------
## brfss <- read.csv(file.choose()) # 'BRFSS-subset.csv'
## brfss2010 <- brfss[brfss$Year == "2010",]


## ----ggplot2-density, eval=FALSE-----------------------------------------
## library(ggplot2)
## ggplot(brfss2010) + geom_density(alpha=.2) +
##     aes(sqrt(Weight), fill=Sex)


## ----shiny, eval=FALSE---------------------------------------------------
## system.file(package="SummerX", "shiny")


