setGeneric("plotByCycle", function(x, ...) standardGeneric("plotByCycle"))

setMethod("plotByCycle", "DNAStringSet",
    function(x, ..., encoding=c("A", "C", "G", "T", "N"), legend.x="topright")
{
    abc <- alphabetByCycle(x)[encoding,,drop=FALSE]
    matplot(t(abc), lty=1, type="l", xlab="Cycle", ylab="Count", ...)
    legend(legend.x, legend=encoding, lty=1, col=seq_along(encoding),
           box.lwd=0)
    invisible(abc)
})

setMethod("plotByCycle", "QualityScore", function(x, ...) {
    enc <- encoding(x)
    abc <- alphabetByCycle(quality(x))[names(enc),]
    df <- data.frame(Cycle=factor(col(abc)), Quality=enc, Weight=as.vector(abc),
                     row.names=NULL)
    
    lbls <- seq_len(ncol(abc))
    lbls <- ifelse(lbls %% 10 == 0, lbls, "")
    ggplot(df, aes(x = Cycle, y = Quality, weight = Weight)) +
        geom_boxplot(outlier.shape=".") + scale_x_discrete(labels=lbls)
})
