.load_NA12878.20.fastq <- function() {
  FastqFile(.lazyFile("NA12878.20.fastq.gz", function(f) {
    fastq <- .bamToFastq(NA12878.20.bam, f)
    message("compressing ", fastq)
    bgzip(fastq)
    unlink(fastq)
    f
  }))
}

.load_NA12878.20.bam <- function() {
  BamFile("NA12878.HiSeq.WGS.bwa.cleaned.recal.b37.20.bam")
}

.load_NA12878.20.vcf <- function() {
  TabixFile("CEUTrio.HiSeq.WGS.b37.bestPractices.phased.b37.vcf.gz")
}
