.bamToFastq <- function(bam.file, fastq.file) {
  message("converting ", path(bam.file), " to a fastq...")
  if (file_ext(fastq.file) == "gz")
    fastq.file <- file_path_sans_ext(fastq.file)
  param <- ScanBamParam(what = c("seq", "qual", "strand", "qname"),
                        reverseComplement=TRUE)
  bam.file <- BamFile(path(bam.file), yieldSize = 1e6)
  open(bam.file)
  on.exit(close(bam.file))
  if (file.exists(fastq.file)) {
    unlink(fastq.file)
  }
  while(isIncomplete(bam.file)) {
    bam <- scanBam(bam.file, param=param)[[1]]
    seq <- bam$seq
    writeFastq(ShortReadQ(seq, bam$qual, BStringSet(bam$qname)), fastq.file,
                          mode="a")
  }
}
