dbSNPFilter <-
    function(dbSNP=character(0), .name="dbSNPFilter")
{
    #.check_type_and_length(regex, "character", 0:1)
    require(dbSNP, quietly=TRUE, character.only=TRUE)
    function(x) {
        x <- rowData(x)
        .idx <- logical(length(x))
        nms <- rep(runValue(seqnames(x)), runLength(seqnames(x)))
        df <- data.frame(chrom=nms, start=start(x), index=seq_len(length(x)))
        snps <- df[width(x) == 1,]
        chr <- names(getSNPcount())[names(getSNPcount()) %in% snps$chrom]
        res <- lapply(chr, function(i, snps) {
            s <- getSNPlocs(i)
            q <- snps[snps$chrom %in% i,]
            dbsnp <- q$start %in% s$loc
            q$index[dbsnp]
        }, snps)
        .idx[do.call(rbind, res)] <- TRUE
        .idx
    }
}
