### R code from vignette source 'ReadsAndAlignments.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width=90)
library(useR2013)


###################################################
### code chunk number 2: fastq-format
###################################################
fls <- dir(file.path(bigdata(), "fastq"), full=TRUE)
cat(noquote(readLines(fls[[1]], 4)), sep="\n")


###################################################
### code chunk number 3: ascii
###################################################
cat(rawToChar(as.raw(32+1:47)),
    rawToChar(as.raw(32+48:94)), sep="\n")


###################################################
### code chunk number 4: readFastq
###################################################
fastqDir <- file.path(bigdata(), "fastq")
fastqFiles <- dir(fastqDir, full=TRUE)
fq <- readFastq(fastqFiles[1])
fq


###################################################
### code chunk number 5: sread
###################################################
head(sread(fq), 3)
head(quality(fq), 3)


###################################################
### code chunk number 6: width-ShortReadQ
###################################################
abc <- alphabetByCycle(sread(fq))
abc[1:4, 1:8]


###################################################
### code chunk number 7: FastqSampler
###################################################
sampler <- FastqSampler(fastqFiles[1], 1000000)
yield(sampler) # sample of 1000000 reads


###################################################
### code chunk number 8: qa (eval = FALSE)
###################################################
## ## Bioc 2.13 only; see ?qa for Bioc 2.12
## qas <- qa(fastqFiles, type="fastq")
## rpt <- report(qas, dest=tempfile())
## browseURL(rpt)


###################################################
### code chunk number 9: report (eval = FALSE)
###################################################
## rpt <- system.file("GSM461176_81_qa_report", "index.html",
##                    package="useR2013")
## browseURL(rpt)


###################################################
### code chunk number 10: fastq-discovery
###################################################
dir(bigdata())
fls <- dir(file.path(bigdata(), "fastq"), full=TRUE)


###################################################
### code chunk number 11: fastq-input-gc
###################################################
rm(fq); invisible(gc())


###################################################
### code chunk number 12: fastq-input
###################################################
fq <- readFastq(fls[1])


###################################################
### code chunk number 13: gcC
###################################################
alf0 <- alphabetFrequency(sread(fq), as.prob=TRUE, collapse=TRUE)
sum(alf0[c("G", "C")])


###################################################
### code chunk number 14: gc-reads
###################################################
gc <- gcFunction(sread(fq))
hist(gc)


###################################################
### code chunk number 15: abc
###################################################
abc <- alphabetByCycle(sread(fq))
matplot(t(abc[c("A", "C", "G", "T"),]), type="l")


###################################################
### code chunk number 16: abc-mclapply (eval = FALSE)
###################################################
## library(parallel)
## gc0 <- mclapply(fls, function(fl) {
##   fq <- readFastq(fl)
##   gc <- gcFunction(sread(fq))
##   table(cut(gc, seq(0, 1, .05)))
## })
## ## simplify list of length 2 to 2-D array
## gc <- simplify2array(gc0)
## matplot(gc, type="s")


###################################################
### code chunk number 17: SAM
###################################################
fl <- system.file("extdata", "ex1.sam", package="Rsamtools")
strsplit(readLines(fl, 1), "\t")[[1]]


###################################################
### code chunk number 18: readGappedAlignments
###################################################
alnFile <- system.file("extdata", "ex1.bam", package="Rsamtools")
aln <- readGappedAlignments(alnFile)
head(aln, 3)


###################################################
### code chunk number 19: GappedAlignments-accessors
###################################################
table(strand(aln))
table(width(aln))
head(sort(table(cigar(aln)), decreasing=TRUE))


###################################################
### code chunk number 20: bam-ex-fls
###################################################
fls <- dir(file.path(bigdata(), "bam"), ".bam$", full=TRUE)
names(fls) <- sub("_.*", "", basename(fls))


###################################################
### code chunk number 21: bam-ex-input
###################################################
## input
aln <- readGappedAlignments(fls[1])
xtabs(~seqnames + strand, as.data.frame(aln))


###################################################
### code chunk number 22: bam-ex-roi
###################################################
data(ex)             # from an earlier exercise


###################################################
### code chunk number 23: bam-ex-strand
###################################################
strand(aln) <- "*"   # protocol not strand-aware


###################################################
### code chunk number 24: bam-ex-hits
###################################################
hits <- findOverlaps(aln, ex)


###################################################
### code chunk number 25: qhits
###################################################
qhits <- countQueryHits(hits)
table(qhits)


###################################################
### code chunk number 26: qhits-keep
###################################################
keep <- which(qhits == 1)


###################################################
### code chunk number 27: bam-ex-cnt
###################################################
cnt <- countSubjectHits(hits[queryHits(hits) %in% keep])


###################################################
### code chunk number 28: bam-count-fun
###################################################
counter <-
    function(filePath, range)
{
    hits <- findOverlaps(aln, ex)
    keep <- which(countQueryHits(hits) == 1)
    cnts <- countSubjectHits(hits[queryHits(hits) %in% keep])
    setNames(cnts, names(ex))
}


###################################################
### code chunk number 29: bam-count-all
###################################################
counts <- sapply(fls, counter, ex)
counts


###################################################
### code chunk number 30: bam-count-mclapply (eval = FALSE)
###################################################
## if (require(parallel))
##     simplify2array(mclapply(fls, counter, ex))


###################################################
### code chunk number 31: gc-read
###################################################
param <- ScanBamParam(what="seq")
seqs <- scanBam(fls[[1]], param=param)
readGC <- gcFunction(seqs[[1]][["seq"]])
hist(readGC)


