### R code from vignette source 'ChIPSeq.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width=90)
library(useR2013)


###################################################
### code chunk number 2: chipseq-report
###################################################
rpt <- system.file("GSE30263_qa_report", "index.html",
           package="useR2013", mustWork=TRUE)
if (interactive())
    browseURL(rpt)


###################################################
### code chunk number 3: chipseq-halfpeak-stamFile
###################################################
stamFile <- system.file("data", "stam.Rda", package="useR2013")
load(stamFile)
stam


###################################################
### code chunk number 4: chipseq-stam
###################################################
head(colData(stam), 3)
head(rowData(stam), 3)
xtabs(~Replicate + CellLine, colData(stam))[,1:5]


###################################################
### code chunk number 5: chipseq-stam-detect
###################################################
m <- assays(stam)[["Tags"]] > 0 # peaks detected...
peaksPerSample <- table(rowSums(m))
head(peaksPerSample)
tail(peaksPerSample)


###################################################
### code chunk number 6: chipseq-stam-similarity-1
###################################################
library(bioDist)                   # for cor.dist
m <- asinh(assays(stam)[["Tags"]]) # transformed tag counts
d <- cor.dist(t(m))                # correlation distance
h <- hclust(d)                     # hierarchical clustering


###################################################
### code chunk number 7: chipseq-stam-similarity-plot (eval = FALSE)
###################################################
## plot(h, cex=.8, ann=FALSE)


###################################################
### code chunk number 8: chipseq-stam-similarity
###################################################
png("chipseq-stam-similarity.png", width=1280)
opar <- par(mar=c(0, 0, 0, 0))
plot(h, axes=FALSE, ann=FALSE)
par(opar)
invisible(dev.off())


###################################################
### code chunk number 9: chipseq-CTCF-PWM-setup
###################################################
library(Biostrings)
library(BSgenome.Hsapiens.UCSC.hg19)
library(seqLogo)
library(lattice)
pwm <- getJASPAR("MA0139.1") # useR2013::getJASPAR


###################################################
### code chunk number 10: chipseq-CTCF-PWM-binding
###################################################
chrid <- "chr1"
hits <-matchPWM(pwm, Hsapiens[[chrid]]) # '+' strand
scores <- PWMscoreStartingAt(pwm, subject(hits), start(hits))


###################################################
### code chunk number 11: chipseq-CTCF-PWM-densityplot (eval = FALSE)
###################################################
## densityplot(scores, xlim=range(scores), pch="|")


###################################################
### code chunk number 12: CTCF-PWM-found
###################################################
cm <- consensusMatrix(hits)[1:4,]
seqLogo(makePWM(scale(cm, FALSE, colSums(cm))))


