
## ----lm-constructor------------------------------------------------------
x <- rnorm(1000)
df <- data.frame(x=x, y=x + rnorm(length(x), sd=.5))
fit <- lm(y ~ x, df)
fit


## ----lm-properties-------------------------------------------------------
is.list(fit)
names(fit)
str(head(fit, 3))


## ------------------------------------------------------------------------
print


## ------------------------------------------------------------------------
head(print.lm) 


## ----setClass------------------------------------------------------------
.Empl <- setClass("Empl",
    representation(person="character", job="character"))

setMethod(show, "Empl", function(object) {
    len <- length(object@person)
    cat("class: ", class(object), " (n =", len, ")\n", sep="")
    cat("person:", head(object@person), if (len > 6) "...", "\n")
    cat("job:", head(object@job), if (len > 6) "...", "\n")
})

.Empl()
.Empl(person=c("Xavier", "Melanie", "Octavio"),
      job=c("Leader", "Innovator", "Doer"))
.Empl(person=LETTERS, job=letters)


## ----FastqStreamer, eval=FALSE-------------------------------------------
## library(ShortRead)
## example(FastqStreamer)


