
## ----bank-account--------------------------------------------------------
account <- function(initial=0) {
    available <- initial
    list(deposit=function(amount) {
        available <<- available + amount
        available
    }, balance=function() {
         available
    })
}
my_acct <- account()
my_acct$deposit(100)
your_acct <- account(20)
my_acct$deposit(200)
my_acct$balance()
your_acct$balance()


## ----internals, eval=FALSE-----------------------------------------------
## x <- 1:5; tracemem(x)
## x[1] <- 2L
## x[1] <- 2
## 
## x <- y <- seq(1, 5); tracemem(x)
## x[1] <- 2L
## 
## df <- data.frame(x=1:5, y=5:1)
## tracemem(df); tracemem(df$x)
## df[1,1] <- 2
## 
## m <- matrix(1:10, 2); tracemem(m)
## m[1, 1] <- 2L
## 
## f <- function(x) x[1]
## g <- function(x) { x[1] <- 2L; x }
## tracemem(x <- 1:5); f(x)
## tracemem(x <- 1:5); g(x)


## ----sexp----------------------------------------------------------------
x <- 1:5
.Internal(inspect(x))


## ----sexp-types, eval=FALSE----------------------------------------------
## .Internal(inspect(pi))
## .Internal(inspect(data.frame()))
## .Internal(inspect(function() {}))
## .Internal(inspect(expression(1 + 2)))


## ----named-0-------------------------------------------------------------
.Internal(inspect(1:5))


## ----named-1-------------------------------------------------------------
.Internal(inspect(x <- 1:5))


## ----named-2-------------------------------------------------------------
.Internal(inspect(y <- x <- 1:5))


## ----styles-data---------------------------------------------------------
set.seed(123)
x <- rnorm(10000000)


## ----declarative-find----------------------------------------------------
x[abs(x) > 5 * sd(x)]


## ----imperative-find, eval=FALSE-----------------------------------------
## ans <- numeric()
## for (xi in x)
##     if (xi > 5 * sd(x))
##         ans <- c(ans, xi)


## ----declarative-clamp---------------------------------------------------
x[abs(x) > 5 * sd(x)] <- 5 * sd(x)


## ----imperative-clamp, eval=FALSE----------------------------------------
## for (i in seq_along(x))
##     if (abs(x[i]) > 5 * sd(x))
##         x[i] <- 5 * sd(x)


## ----functional----------------------------------------------------------
df <- data.frame(x=1:5, y=5:1)
x0 <- sapply(names(df), function(x) sqrt(df[[x]]))
x1 <- sapply(names(df), function(x, df) sqrt(df[[x]]), df)
x3 <- sapply(df, function(x, fun) fun(x), sqrt)
x2 <- sapply(df, sqrt)


