### R code from vignette source 'morgan-annotation.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(Morgan2013)
op <- options(prompt="  ", continue="  ")


###################################################
### code chunk number 2: select (eval = FALSE)
###################################################
## library(org.Hs.eg.db)
## keytypes(org.Hs.eg.db)       # available queries
## keys(org.Hs.eg.db, "SYMBOL") # possible 'SYMBOL' values
## cols(org.Hs.eg.db)           # available return values
## select(org.Hs.eg.db, "TERT", keytype="SYMBOL",
##     c("ENTREZID", "GENENAME", "GO"))


###################################################
### code chunk number 3: TxDb-select (eval = FALSE)
###################################################
## library(TxDb.Hsapiens.UCSC.hg19.knownGene)
## txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
## select(txdb, "7015", keytype="GENEID", "TXNAME")


###################################################
### code chunk number 4: TxDb-exonsBy (eval = FALSE)
###################################################
## exonsBy(txdb, "tx")
## exonsBy(txdb, "gene")["7015"]


###################################################
### code chunk number 5: AnnotationHub (eval = FALSE)
###################################################
## library(AnnotationHub)
## hub <- AnnotationHub()  # query for available resources
## ## metadata(hub) -- info. about available resources
## ## hub$<tab> -- tab completion to select resource


###################################################
### code chunk number 6: tabix (eval = FALSE)
###################################################
## library(Rsamtools)
## indexTabix("chr22.vcf.gz", type="vcf4")


###################################################
### code chunk number 7: vcf-discovery (eval = FALSE)
###################################################
## library(VariantAnnotation)
## scanVcfHeader("chr22.vcf.gz")


###################################################
### code chunk number 8: vcf-query (eval = FALSE)
###################################################
## which <- GRanges("22", 
##     IRanges(c(321680, 14477080), c(321689, 14477090)))
## param <- ScanVcfParam(info=c("AN", "LDAF"), geno=NA,
##     which=which)
## readVcf("chr22.vcf.gz", "hg19", param=param)


