isInDbSNP <- 
    function(vcf, seqname, rsid=TRUE) 
{
    snpLocs <- getSNPlocs(seqname)
    idx <-                    # correct seqname, width of variant == 1
        ((seqnames(vcf) == seqname) & (width(rowData(vcf)) == 1L))
    idx <- as.vector(idx)
    snps <- rowData(vcf)[idx]
    result <- rep(NA, nrow(vcf))
    result[idx] <- if (rsid) {
        sub("rs", "", names(snps)) %in% snpLocs[["RefSNP_id"]]
    } else {
        start(snps) %in% snpLocs[["loc"]]
    }
    result
}
