library(shiny)
library(lattice)
library(parathyroidSE)

shinyServer(function(input, output) {

  dataset <- reactive({
      data(parathyroidGenesSE)
      parathyroidGenesSE
  })

  output$overview <- renderPrint({
      print(dataset())
  })

  output$expt_data <- renderPrint({
    print(exptData(dataset())[[1]])
  })

  output$col_data <- renderTable({
    df0 <-colData(dataset())
    df <- as.data.frame(df0[, 3:8])
    rownames(df) <- df0$run
    df
  })

})
