library(shiny)

shinyUI(pageWithSidebar(

  headerPanel("SummarizedExperiment Viewer"),

  sidebarPanel(
    checkboxInput("show_expt_data",
                  "Experiment data"),
    checkboxInput("show_col_data",
                  "Column data"),
    selectInput("transform", "Transform",
        choices = c("none", "asinh", "sqrt",
          "log1"))
      ),
  
  mainPanel(
    verbatimTextOutput("overview"),
    conditionalPanel(
        "input.show_expt_data == true",
        verbatimTextOutput("expt_data")),
    conditionalPanel(
        "input.show_col_data == true",
        tableOutput("col_data")),
    plotOutput("heatmap"))

))
