### R code from vignette source 'D2_GenomicAnnotations.Rnw'

###################################################
### code chunk number 1: txdb
###################################################
library(TxDb.Dmelanogaster.UCSC.dm3.ensGene)
txdb <- TxDb.Dmelanogaster.UCSC.dm3.ensGene


###################################################
### code chunk number 2: de
###################################################
library(Morgan2013)
library(edgeR)
data(lrTest)
fbids <- rownames(topTags(lrTest))


###################################################
### code chunk number 3: flybase-tx-gn
###################################################
txnm <- select(txdb, fbids, "TXNAME", "GENEID")
nrow(txnm)
head(txnm, 3)


###################################################
### code chunk number 4: cdsBy
###################################################
cds <- cdsBy(txdb, "tx", use.names=TRUE)[txnm$TXNAME]
length(cds)
cds[1]


###################################################
### code chunk number 5: BSgenome
###################################################
library(BSgenome.Dmelanogaster.UCSC.dm3)
txx <- extractTranscriptsFromGenome(Dmelanogaster, cds)
length(txx)
head(txx, 3)
head(translate(txx), 3)


###################################################
### code chunk number 6: makeTranscriptDbFromUCSC-discover
###################################################
library(rtracklayer)
library(GenomicFeatures)

## genomes
gnms <- ucscGenomes()
nrow(gnms)
gnms[grep("elegans", gnms$species),]

## tables
tbls <- supportedUCSCtables()
nrow(tbls)
head(tbls)


###################################################
### code chunk number 7: makeTranscriptDbFromUCSC-make (eval = FALSE)
###################################################
## ## Not run
## txdb <- makeTranscriptDbFromUCSC("ce10", "refGene")
## saveDb(txdb, file="/path/to/file.sqlite")


