### R code from vignette source 'D1_GeneAnnotations.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(digits=2)
library(org.Dm.eg.db)
CONNECTION_OK <- tryCatch({ 
    con <- url("http://google.com", "r"); close(con); TRUE
}, error=function(...) FALSE)


###################################################
### code chunk number 2: PKG_OK
###################################################
PKG_OK <- packageDescription("Morgan2013")$Version >= "0.9.0"
stopifnot(PKG_OK)


###################################################
### code chunk number 3: select
###################################################
library(org.Dm.eg.db)
cols(org.Dm.eg.db)
keytypes(org.Dm.eg.db)
uniprotKeys <- head(keys(org.Dm.eg.db, keytype="UNIPROT"))
cols <- c("SYMBOL", "PATH")
select(org.Dm.eg.db, keys=uniprotKeys, cols=cols, keytype="UNIPROT")


###################################################
### code chunk number 4: select-kegg
###################################################
kegg <- select(org.Dm.eg.db, "00310", c("UNIPROT", "SYMBOL"), "PATH")
nrow(kegg)
head(kegg, 3)


###################################################
### code chunk number 5: tt-to-eg
###################################################
library(Morgan2013)
library(edgeR)
library(org.Dm.eg.db)
data(lrTest)
tt <- as.data.frame(topTags(lrTest))


###################################################
### code chunk number 6: tt-to-eg2
###################################################
fbids <- rownames(tt)
cols <- c("ENTREZID", "SYMBOL")
anno <- select(org.Dm.eg.db, fbids, cols, "FLYBASE")
ttanno <- merge(tt, anno, by.x=0, by.y="FLYBASE")
dim(ttanno)
head(ttanno, 3)


###################################################
### code chunk number 7: biomaRt1 (eval = FALSE)
###################################################
## library(biomaRt)
## head(listMarts(), 3)                      ## list the marts
## head(listDatasets(useMart("ensembl")), 3) ## mart datasets
## ensembl <-                                ## fully specified mart
##     useMart("ensembl", dataset = "hsapiens_gene_ensembl")
## 
## head(listFilters(ensembl), 3)             ## filters
## myFilter <- "chromosome_name"
## head(filterOptions(myFilter, ensembl), 3) ## return values
## myValues <- c("21", "22")
## head(listAttributes(ensembl), 3)          ## attributes
## myAttributes <- c("ensembl_gene_id","chromosome_name")
## 
## ## assemble and query the mart
## res <- getBM(attributes =  myAttributes, filters =  myFilter,
##              values =  myValues, mart = ensembl)


