### R code from vignette source 'morgan-r-bioconductor-intro.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(Morgan2013)


###################################################
### code chunk number 2: vectors
###################################################
x <- c(1, 2, 3, 4, 5)
x
log(x)
x[c(3, 2)]
x[3:2]
x[c(TRUE, FALSE)]


###################################################
### code chunk number 3: data-frames
###################################################
df <- data.frame(
    age = c(17, 23, 32, 37),
    sex = c("Male", "Female", "Female", "Male"))
df
df[df$age < 30 & df$sex == "Male", ]


###################################################
### code chunk number 4: matrixs
###################################################
m <- matrix(1:8, 2, 4)
m
log(m)
rowSums(m)


###################################################
### code chunk number 5: stat-concepts
###################################################
df$sex
df$height <- c(180, 172, NA, 177)
df


###################################################
### code chunk number 6: biocLite (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("data.table")


###################################################
### code chunk number 7: library (eval = FALSE)
###################################################
## library(lattice)


###################################################
### code chunk number 8: help (eval = FALSE)
###################################################
## help.start()
## ?t.test
## vignette("datatable-faq")


###################################################
### code chunk number 9: setup
###################################################
library(ShortRead)
op <- options(showHeadLines=3, showTailLines=1)


###################################################
### code chunk number 10: readFastq
###################################################
library(ShortRead)
fq <- 
  readFastq("~/BigData/fastq/SRR031724_1_subset.fastq")
fq          # 'S4' class
sread(fq)   # 'generic' and 'method'; another S4 class


###################################################
### code chunk number 11: S4-help (eval = FALSE)
###################################################
## ?sread
## ?"reverseComplement<tab>"  # tab key for completions!
## ?"reverseComplement,DNAStringSet-method"


###################################################
### code chunk number 12: S4-discovery (eval = FALSE)
###################################################
## showMethods("reverseComplement")
## showMethods(class="DNAStringSet", where=search())
## selectMethod("reverseComplement", "DNAStringSet")


