### R code from vignette source 'A11_R.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(SequenceAnalysisData)


###################################################
### code chunk number 2: prompt
###################################################
## assign values 5, 4, 3, 2, 1 to variable 'x'
x <- c(5, 4, 3, 2, 1)
x


###################################################
### code chunk number 3: colon
###################################################
x[2:4]


###################################################
### code chunk number 4: log
###################################################
log(x)


###################################################
### code chunk number 5: types
###################################################
c(1.1, 1.2, 1.3)         # numeric
c(FALSE, TRUE, FALSE)    # logical
c("foo", "bar", "baz")   # character, single or double quote ok
as.character(x)          # convert 'x' to character
typeof(x)                # the number 5 is numeric, not integer
typeof(2L)               # append 'L' to force integer
typeof(2:4)              # ':' produces a sequence of integers


###################################################
### code chunk number 6: factor
###################################################
sex <- factor(c("Male", "Female", NA), levels=c("Female", "Male"))
sex


###################################################
### code chunk number 7: lists
###################################################
lst <- list(a=1:3, b=c("foo", "bar"), c=sex)
lst


###################################################
### code chunk number 8: list-subset
###################################################
lst[c(3, 1)]             # another list -- class isomorphism
lst[["a"]]               # the element itself, selected by name


###################################################
### code chunk number 9: data.frame
###################################################
df <- data.frame(age=c(27L, 32L, 19L),
                 sex=factor(c("Male", "Female", "Male")))
df
df[c(1, 3),]
df[df$age > 20,]


###################################################
### code chunk number 10: matrix
###################################################
m <- matrix(1:12, nrow=3)
m
m[c(1, 3), c(2, 4)]


###################################################
### code chunk number 11: matrix-subset
###################################################
m[, 3]
m[, 3, drop=FALSE]


###################################################
### code chunk number 12: lm
###################################################
x <- rnorm(1000, sd=1)
y <- x + rnorm(1000, sd=.5)
fit <- lm(y ~ x)       # formula describes linear regression 
fit                    # an 'S3' object
anova(fit)
sqrt(var(resid(fit)))  # residuals accessor and subsequent transforms
class(fit)


###################################################
### code chunk number 13: function-args
###################################################
y <- 5:1
log(y)
args(log)        # arguments 'x' and 'base'; see ?log
log(y, base=2)   # 'base' is optional, with default value
try(log())       # 'x' required; 'try' continues even on error
args(data.frame) # ... represents variable number of arguments


###################################################
### code chunk number 14: named-args
###################################################
log(base=2, y)   # match argument 'base' by name, 'x' by position


###################################################
### code chunk number 15: S3-method-args
###################################################
args(anova)
args(anova.glm)


###################################################
### code chunk number 16: fail
###################################################
f <- function(i) {
    if (i < 0)
        stop("i is negative")
    rnorm(i)
}
lapply(0:1, f)


###################################################
### code chunk number 17: tryCatch
###################################################
lapply(-1:1, function(i) {
    tryCatch({
        f(i)
    }, error=function(err) {
        ## return 'NA' when error occurs, instead of stopping
        NA_real_
    })
})


###################################################
### code chunk number 18: lattice
###################################################
library(lattice)
plt <- dotplot(variety ~ yield | site, data = barley, groups = year,
               xlab = "Barley Yield (bushels/acre)" , ylab=NULL,
               key = simpleKey(levels(barley$year), space = "top", 
                 columns=2),
               aspect=0.5, layout = c(2,3))
print(plt)


###################################################
### code chunk number 19: search
###################################################
length(search())
search()


###################################################
### code chunk number 20: double-colon
###################################################
pi <- 3.2    ## http://en.wikipedia.org/wiki/Indiana_Pi_Bill
base::pi
rm(pi)       ## remove from the .GlobalEnv


###################################################
### code chunk number 21: package (eval = FALSE)
###################################################
## library(StatisticalComputing2013)
## sessionInfo()


###################################################
### code chunk number 22: help-start (eval = FALSE)
###################################################
## help.start()


###################################################
### code chunk number 23: help (eval = FALSE)
###################################################
## ?data.frame
## ?lm
## ?anova             # a generic function
## ?anova.lm          # an S3 method, specialized for 'lm' objects


###################################################
### code chunk number 24: S3-interactive
###################################################
methods(anova)
methods(class="glm")


###################################################
### code chunk number 25: S3-view (eval = FALSE)
###################################################
## anova.lm
## getAnywhere("anova.loess")


###################################################
### code chunk number 26: head-src
###################################################
utils::head
methods(head)
head(head.matrix)


###################################################
### code chunk number 27: vignette (eval = FALSE)
###################################################
## vignette(package="StatisticalComputing2013")


###################################################
### code chunk number 28: rbioc-pdata
###################################################
pdataFile <- system.file(package="SequenceAnalysisData", "extdata", 
                         "pData.csv")


###################################################
### code chunk number 29: rbioc-pdata-csv
###################################################
pdata <- read.table(pdataFile)  
dim(pdata)
names(pdata)
summary(pdata)


###################################################
### code chunk number 30: rbioc-pdata-subset
###################################################
head(pdata[,"sex"], 3)
head(pdata$sex, 3)
head(pdata[["sex"]], 3)
sapply(pdata, class)


###################################################
### code chunk number 31: rbioc-pdata-sextab
###################################################
table(pdata$sex, useNA="ifany")


###################################################
### code chunk number 32: rbioc-pdata-molbiol
###################################################
with(pdata, table(mol.biol, useNA="ifany"))


###################################################
### code chunk number 33: rbbioc-pdata-bcrabl
###################################################
ridx <- pdata$mol.biol %in% c("BCR/ABL", "NEG")


###################################################
### code chunk number 34: rbioc-pdata-molbiol-selected
###################################################
table(ridx)
sum(ridx)


###################################################
### code chunk number 35: rbioc-pdata-subset
###################################################
pdata1 <- pdata[ridx,]


###################################################
### code chunk number 36: rbioc-pdata-subset-levels
###################################################
levels(pdata1$mol.biol)


###################################################
### code chunk number 37: rbioc-pdata-subset-recode
###################################################
pdata1$mol.biol <- factor(pdata1$mol.biol)
table(pdata1$mol.biol)


###################################################
### code chunk number 38: rbioc-pdata-age-molbiol
###################################################
with(pdata1, t.test(age ~ mol.biol))


###################################################
### code chunk number 39: rbioc-pdata-boxplot (eval = FALSE)
###################################################
## ## not evaluated
## boxplot(age ~ mol.biol, pdata1)


